firewall {
    all-ping enable
    broadcast-ping disable
    conntrack-expect-table-size 4096
    conntrack-hash-size 4096
    conntrack-table-size 32768
    conntrack-tcp-loose enable
    group {
    }
    ipv6-receive-redirects disable
    ipv6-src-route disable
    ip-src-route disable
    log-martians enable
    name WAN_IN {
        default-action accept
        description "packets from Internet to LAN & WLAN"
        enable-default-log
        rule 1 {
            action accept
            description "allow established sessions"
            log disable
            protocol all
            state {
                established enable
                invalid disable
                new disable
                related enable
            }
        }
        rule 2 {
            action accept
            description "3CX SIP"
            destination {
                address 192.168.20.100
                port 5060
            }
            log disable
            protocol tcp_udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 3 {
            action accept
            description "3CX Proxy"
            destination {
                address 192.168.20.100
                port 5090
            }
            log disable
            protocol tcp_udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 4 {
            action accept
            description "3CX Tunnel"
            destination {
                address 192.168.20.100
                port 5080-5089
            }
            log disable
            protocol tcp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 5 {
            action accept
            description "3CX Abyss"
            destination {
                address 192.168.20.100
                port 5000
            }
            log disable
            protocol tcp_udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 6 {
            action accept
            description "3CX Port"
            destination {
                address 192.168.20.100
                port 4515
            }
            log disable
            protocol udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 7 {
            action accept
            description "3CX Ports"
            destination {
                address 192.168.20.100
                port 5480-5488
            }
            log disable
            protocol udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 8 {
            action accept
            description "3CX RTP"
            destination {
                address 192.168.20.100
                port 9000-9049
            }
            log disable
            protocol udp
            state {
                established enable
                invalid enable
                new disable
                related enable
            }
        }
        rule 9 {
            action drop
            description "drop invalid state"
            log disable
            protocol all
            state {
                established disable
                invalid enable
                new disable
                related disable
            }
        }
    }
    name WAN_LOCAL {
        default-action accept
        description "packets from Internet to the router"
        enable-default-log
        rule 1 {
            action accept
            description "allow established session to the router"
            log disable
            protocol all
        }
        rule 2 {
            action drop
            description "drop invalid state"
            log enable
            protocol all
        }
    }
    receive-redirects disable
    send-redirects enable
    source-validation disable
    syn-cookies enable
}
interfaces {
    bridge br0 {
        address 192.168.20.1/23
        aging 300
        hello-time 2
        max-age 20
        priority 0
        stp false
    }
    ethernet eth0 {
        address 74.211.56.250/30
        description WAN
        duplex auto
        firewall {
            in {
                name WAN_IN
            }
            local {
                name WAN_LOCAL
            }
        }
        speed auto
    }
    ethernet eth1 {
        bridge-group {
            bridge br0
        }
        description LAN
        duplex auto
        speed auto
    }
    ethernet eth2 {
        bridge-group {
            bridge br0
        }
        description LAN2
        duplex auto
        speed auto
    }
    loopback lo {
    }
}
protocols {
    static {
    }
}
service {
    dhcp-server {
        disabled false
        shared-network-name Wired1 {
            authoritative disable
            subnet 192.168.20.0/23 {
                default-router 192.168.20.1
                dns-server 192.168.20.1
                lease 86400
                start 192.168.20.100 {
                    stop 192.168.20.125
                }
                static-mapping PhoneServer {
                    ip-address 192.168.20.100
                    mac-address A0:42:3F:00:8B:71
                }
            }
        }
    }
    dns {
        forwarding {
            cache-size 150
            listen-on br0
        }
    }
    gui {
        https-port 443
    }
    nat {
        rule 1 {
            description "3CX SIP"
            destination {
                address 74.211.56.250
                port 5060
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 5060
            }
            log disable
            protocol tcp_udp
            type destination
        }
        rule 2 {
            description "3CX Proxy"
            destination {
                address 74.211.56.250
                port 5090
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 5090
            }
            log disable
            protocol tcp_udp
            type destination
        }
        rule 3 {
            description "3CX Tunnel"
            destination {
                address 74.211.56.250
                port 5080-5089
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 5080-5089
            }
            log disable
            protocol tcp
            type destination
        }
        rule 4 {
            description "3CX Abyss"
            destination {
                address 74.211.56.250
                port 5000
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 5000
            }
            log disable
            protocol tcp_udp
            type destination
        }
        rule 5 {
            description "3CX Port"
            destination {
                address 74.211.56.250
                port 4515
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 4515
            }
            log disable
            protocol udp
            type destination
        }
        rule 6 {
            description "3CX Ports"
            destination {
                address 74.211.56.250
                port 5480-5488
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 5480-5488
            }
            log disable
            protocol udp
            type destination
        }
        rule 7 {
            description "3CX Ports"
            destination {
                address 74.211.56.250
                port 9000-9049
            }
            inbound-interface eth0
            inside-address {
                address 192.168.20.100
                port 9000-9049
            }
            log disable
            protocol udp
            type destination
        }
        rule 5000 {
            description "masquerade for WAN"
            log disable
            outbound-interface eth0
            type masquerade
        }
    }
}
system {
    gateway-address 74.211.56.249
    host-name RangePhone
    login {
        user admin {
            authentication {
                encrypted-password $6$dmBzLaSDRQS6R$DkvaakcLhqPYU0ILrLOwww57Za4alSlOF6sF9JGjFocfQkM7uSlboVxZNoN65oXE0J13kB2vpj2VUiCM0MN2o.
                plaintext-password ""
            }
            full-name Administrator
            level admin
        }
    }
    name-server 74.211.57.131
    name-server 74.211.57.132
    name-server 8.8.8.8
    ntp {
        server 0.ubnt.pool.ntp.org {
        }
        server 1.ubnt.pool.ntp.org {
        }
        server 2.ubnt.pool.ntp.org {
        }
        server 3.ubnt.pool.ntp.org {
        }
    }
    offload {
        ipsec enable
        ipv4 {
            forwarding enable
        }
        ipv6 {
            forwarding disable
        }
    }
    syslog {
        global {
            facility all {
                level notice
            }
            facility protocols {
                level debug
            }
        }
    }
    time-zone America/Denver
}


/* Warning: Do not remove the following line. */
/* === vyatta-config-version: "config-management@1:dhcp-relay@1:dhcp-server@4:firewall@4:ipsec@3:nat@3:qos@1:quagga@2:system@4:ubnt-pptp@1:ubnt-util@1:vrrp@1:webgui@1:webproxy@1:zone-policy@1" === */
/* Release version: v1.3.0.4605130.131011.1754 */
