<?php
/**
 Plugin Name: Caldera Forms Add-on For Remote API (Quickbooks)
 Description: Example Caldera Forms processor to send data to a remote API
 */

/**
 * Register processor
 */
add_filter( 'caldera_forms_get_form_processors', function( $processors ) {

		$processors['my_processor_send_to_api'] 	= array(
			'name'              =>  'Remote API',
			'description'       =>  'Send Caldera Forms Data To Remove API',
			'pre_processor'	    =>  'my_processor_send_to_api_pre_process'
		);
	return $processors;
} );

/**
 * Process submission
 *
 * @param array $config Processor config
 * @param array $form Form config
 * @param string $process_id Unique process ID for this submission
 *
 * @return void|array
 */
function my_processor_send_to_api_pre_process( $config, $form, $process_id ){
	//get all form data
	$data = Caldera_Forms::get_submission_data( $form );
	$response = wp_remote_post( 'https://service.com/api/something', array(
		'body' => $data
	));

	//If API responds with success return void
	if( 200 == wp_remote_retrieve_response_code( $response ) || 201 == wp_remote_retrieve_response_code( $response ) ){
		return;
	}

	//find and return error
	if( is_wp_error( $response ) ){
		$error = $response->get_error_message();
	}elseif ( isset( $response[ 'error' ]) ){
		$error =  $response[ 'error' ];
	}else{
		$error = 'Something bad happened';
	}

	//returning in pre-precess stops submission processing.
	return array(
		'note' => $error,
		'type' => 'error'
	);


}