/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import {registerBlockType} from '@wordpress/blocks';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './style.scss';

/**
 * Internal dependencies
 */
import Edit                from './edit';
import metadata            from './block.json';

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {
	icon: {
		src: <svg>
			<g>
				<g>
					<path d="m 6.0749198,9.5296124 c 0,0 -0.381,-0.275 -0.381,-0.275 -0.2779,-0.2122 -0.5737,-0.4602 -0.8116,-0.7156 -0.6116,-0.6563 -1.0463,-1.4197 -1.2405,-2.2987 -0.1066,-0.4834 -0.1253,-0.8802001 -0.1196,-1.3716001 0,0 0.012,-0.127 0.012,-0.127 0,0 0.012,-0.1778 0.012,-0.1778 0.082,-0.8431 0.3084,-1.5756 0.7811,-2.286 0.4413,-0.6632 1.0399,-1.2029 1.723,-1.60780004 0.5137,-0.3044 1.1011,-0.50569996 1.6891,-0.60299996 0.1599,-0.026 0.4261,-0.062 0.5842,-0.062 0,0 0.508,0 0.508,0 0,0 0.127,0.012 0.127,0.012 0.5033,0.034 0.9887,0.1478 1.4605002,0.32599996 0.5314,0.2006 0.9675,0.4662 1.4097,0.82060004 0.1683,0.1349 0.3245,0.2847 0.4711,0.442 0.2214,0.2379 0.4208,0.487 0.5951,0.762 0.6887,1.0874 0.9389,2.4628 0.671,3.7211001 -0.1661,0.7803 -0.5236,1.5111 -1.0209,2.1336 -0.2968,0.3715 -0.5672,0.6414 -0.9322,0.945 -0.1068,0.089 -0.3558,0.2917 -0.4699,0.3504 0,0 0.7239,0.3101 0.7239,0.3101 0.4765,0.2000996 0.9632,0.4262996 1.3843,0.7275996 0,0 0.2286,0.1697 0.2286,0.1697 0.117,0.071 0.3234,0.1201 0.3404,0.2785 0.012,0.1147 -0.091,0.2264 -0.1617,0.3048 -0.1525,0.1682 -0.2934,0.3378 -0.547,0.2836 -0.058,-0.012 -0.1003,-0.032 -0.1524,-0.058 0,0 -0.3302,-0.2168 -0.3302,-0.2168 0,0 -0.3429,-0.2116 -0.3429,-0.2116 -0.3795,-0.2217 -0.7912,-0.4104 -1.2065,-0.5546 -0.6924,-0.2403 -1.4643002,-0.3895 -2.1971002,-0.398 0,0 -0.1905,-0.013 -0.1905,-0.013 0,0 -0.4572,0.013 -0.4572,0.013 0,0 -0.127,0.012 -0.127,0.012 -0.3259,0.022 -0.6443,0.061 -0.9652,0.1256 -0.9263,0.1853 -1.7619,0.5133 -2.5654,1.0111 -1.5715,0.9737 -2.6868,2.4377 -3.2639,4.1857 -0.1095,0.3315 -0.2014,0.7347 -0.2592,1.0795 0,0 -0.071,0.5842 -0.071,0.5842 -2e-4,0.1756 -2e-4,0.3552 0.15249996,0.4759 0.1056,0.083 0.2399,0.098 0.3682,0.1105 0,0 0.5715,0.011 0.5715,0.011 0,0 0.2159,-0.013 0.2159,-0.013 0,0 5.4483,0 5.4483,0 0,0 2.4638002,0 2.4638002,0 0,0 0.1905,-0.013 0.1905,-0.013 0,0 0.889,0 0.889,0 0,0 0.1905,-0.013 0.1905,-0.013 0,0 0.5334,0 0.5334,0 0,0 0.2159,-0.013 0.2159,-0.013 0.1655,-2e-4 0.3324,0.011 0.4953,0.041 0.4683,0.087 0.8627,0.3513 1.2319,0.6391 0,0 0.381,0.3101 0.381,0.3101 0,0 -6.2484002,0 -6.2484002,0 0,0 -2.0828,0 -2.0828,0 0,0 -1.0414,0 -1.0414,0 0,0 -0.1905,0.013 -0.1905,0.013 0,0 -2.286,0 -2.286,0 0,0 -0.1905,-0.013 -0.1905,-0.013 0,0 -0.4064,0 -0.4064,0 -0.3852,0 -0.6989,0.018 -1.07949996,-0.078 -0.2581,-0.065 -0.4901,-0.1857 -0.6342,-0.4175 -0.048,-0.077 -0.08,-0.1543 -0.1059,-0.2413 -0.06,-0.2017 -0.062,-0.4139 -0.06,-0.6223 0,0 0.012,-0.127 0.012,-0.127 0,0 0.049,-0.4318 0.049,-0.4318 0.05,-0.3505 0.1223,-0.6979 0.2083,-1.0414 0.3609,-1.4441 1.03529996,-2.7673 2.06889996,-3.8481 0.5149,-0.5382 1.1081,-0.9966 1.7394,-1.3896 0.4309,-0.2685 0.8822,-0.4989996 1.3462,-0.7040996 0.1318,-0.058 0.5277,-0.2341 0.6477,-0.2558 z m 2.3241,-8.57070014 c 0,0 -0.2921,0.027 -0.2921,0.027 -0.2696,0.033 -0.5682,0.10020004 -0.8255,0.18690004 -0.8735,0.2948 -1.6186,0.8721 -2.1294,1.6383 -0.097,0.1455 -0.1916,0.2991 -0.2668,0.4572 -0.2187,0.4601 -0.3634,0.9512 -0.3989,1.4605 0,0 -0.012,0.127 -0.012,0.127 0,0 0,0.381 0,0.381 5e-4,0.2944 0.09,0.7457001 0.1781,1.0287001 0.3896,1.2534 1.3669,2.2761 2.6159,2.6924 0.3272,0.1091 0.6591,0.1802 1.0033,0.2043 0,0 0.127,0.012 0.127,0.012 0,0 0.3429,0 0.3429,0 0,0 0.1524,-0.012 0.1524,-0.012 0.494,-0.034 0.9722,-0.1593 1.4224002,-0.3655 0,0 0.1651,-0.078 0.1651,-0.078 0.3536,-0.1961 0.6417,-0.3856 0.9398,-0.6633 0.7667,-0.7143 1.2378,-1.7349 1.2832,-2.7802001 0,0 0.012,-0.1651 0.012,-0.1651 0,0 0,-0.1143 0,-0.1143 0,0 -0.012,-0.1397 -0.012,-0.1397 -0.078,-1.7902 -1.3786,-3.3431 -3.1120002,-3.7766 -0.2353,-0.059 -0.4696,-0.094 -0.7112,-0.11070004 0,0 -0.1524,-0.01 -0.1524,-0.01 0,0 -0.3302,0 -0.3302,0 z M 18.83842,10.484812 c 0,0 0.5207,0 0.5207,0 0,0 0.127,0.01 0.127,0.01 0.4751,0.038 0.9826,0.2268 1.3197,0.573 0.1892,0.1942 0.3274,0.4316 0.4196,0.6853 0.074,0.2043 0.1013,0.4201 0.1161,0.635 0,0 0.011,0.127 0.011,0.127 0,0.2948 -0.093,0.5481 -0.2121,0.8128 -0.1042,0.2314 -0.2408,0.4836 -0.3762,0.6985 0,0 -0.303,0.4572 -0.303,0.4572 0,0 -0.568,0.5715 -0.568,0.5715 -0.089,0.097 -0.1311,0.2781 -0.1681,0.4064 0,0 -0.1834,0.5842 -0.1834,0.5842 0,0 -0.065,0.2159 -0.065,0.2159 -0.011,0.035 -0.024,0.081 -0.057,0.1014 -0.026,0.015 -0.069,0.013 -0.099,0.013 0,0 -0.7874,0 -0.7874,0 -0.1088,-2e-4 -0.1171,0 -0.1142,-0.127 0,0 0.049,-0.4572 0.049,-0.4572 0.016,-0.1341 0.049,-0.36 0.097,-0.4826 0.048,-0.1219 0.1332,-0.2468 0.2058,-0.3556 0,0 0.3381,-0.4572 0.3381,-0.4572 0,0 0.6335,-0.6604 0.6335,-0.6604 0,0 0.1079,-0.1143 0.1079,-0.1143 0.047,-0.056 0.1221,-0.197 0.1619,-0.2667 0.1209,-0.2113 0.2984,-0.5947 0.2995,-0.8382 0,0 0,-0.089 0,-0.089 0,-0.4075 -0.2032,-0.8183 -0.5715,-1.0119 -0.1567,-0.082 -0.3947,-0.1289 -0.5715,-0.1311 -0.3419,0 -0.8056,0.1 -1.0155,0.3937 -0.1105,0.1546 -0.1689,0.327 -0.2201,0.508 -0.037,0.1316 -0.013,0.2012 -0.1614,0.2032 0,0 -0.7874,0 -0.7874,0 -0.032,0 -0.083,0 -0.1096,-0.02 -0.022,-0.026 -0.01,-0.064 0,-0.094 0,0 0.044,-0.1905 0.044,-0.1905 0.082,-0.3044 0.1722,-0.5596 0.3233,-0.8382 0.2473,-0.4562 0.7632,-0.7064 1.2534,-0.8101 0,0 0.3429,-0.051 0.3429,-0.051 z m -9.5758002,3.5406 c 0,0 0,-0.5842 0,-0.5842 10e-5,-0.089 0.01,-0.1698 0.068,-0.2408 0.1089,-0.1271 0.3227,-0.1159 0.4152,0.025 0.042,0.064 0.05,0.1414 0.05,0.2158 0,0 0,0.5842 0,0.5842 0,0 0.4445002,-0.2521 0.4445002,-0.2521 0.083,-0.047 0.18,-0.1081 0.2794,-0.099 0.2206,0.019 0.3014,0.2621 0.193,0.4148 -0.052,0.073 -0.1426,0.1153 -0.2184,0.1601 0,0 -0.4191,0.2337 -0.4191,0.2337 0,0 0,0.025 0,0.025 0,0 0.4318,0.2414 0.4318,0.2414 0.068,0.04 0.1603,0.087 0.2051,0.1524 0.1137,0.1661 0.015,0.4012 -0.1924,0.4142 -0.1031,0.01 -0.1935,-0.05 -0.2794,-0.099 0,0 -0.4445002,-0.2521 -0.4445002,-0.2521 0,0 0,0.5715 0,0.5715 -10e-5,0.079 -0.01,0.1599 -0.05,0.2285 -0.088,0.1337 -0.2938,0.1519 -0.4044,0.037 -0.066,-0.068 -0.078,-0.1496 -0.079,-0.24 0,0 0,-0.5969 0,-0.5969 0,0 -0.4318,0.2438 -0.4318,0.2438 -0.081,0.048 -0.1947,0.1154 -0.2921,0.1091 -0.1944,-0.012 -0.3081,-0.2409 -0.2036,-0.4037 0.055,-0.086 0.1319,-0.1168 0.2163,-0.1651 0.09,-0.052 0.3552,-0.2172 0.4318,-0.2413 0,0 0,-0.025 0,-0.025 0,0 -0.4064,-0.225 -0.4064,-0.225 -0.092,-0.053 -0.1947,-0.1 -0.2521,-0.1941 -0.025,-0.042 -0.027,-0.067 -0.027,-0.1143 -2e-4,-0.027 -9e-4,-0.063 0.01,-0.089 0.033,-0.1137 0.1554,-0.198 0.2729,-0.1881 0.087,0.01 0.1675,0.061 0.2413,0.1028 0,0 0.4445,0.2504 0.4445,0.2504 z m 2.9210002,0 c 0,0 0,-0.5715 0,-0.5715 10e-5,-0.083 0.01,-0.1717 0.059,-0.241 0.1054,-0.1466 0.3557,-0.1336 0.4372,0.038 0.044,0.092 0.037,0.2054 0.037,0.3048 0,0 0,0.4699 0,0.4699 0,0 0.4445,-0.2521 0.4445,-0.2521 0.088,-0.05 0.1737,-0.105 0.2794,-0.097 0.2159,0.016 0.3061,0.2531 0.193,0.4124 -0.052,0.073 -0.1426,0.1153 -0.2184,0.1601 0,0 -0.4191,0.2337 -0.4191,0.2337 0,0 0,0.025 0,0.025 0,0 0.4318,0.2412 0.4318,0.2412 0.082,0.048 0.1616,0.081 0.2141,0.1652 0.1066,0.1708 -0.01,0.4049 -0.2268,0.4041 -0.092,-2e-4 -0.1772,-0.057 -0.254,-0.1012 0,0 -0.4445,-0.2521 -0.4445,-0.2521 0,0 0,0.508 0,0.508 0,0.1038 0.01,0.2002 -0.05,0.292 -0.089,0.1346 -0.293,0.1528 -0.4044,0.037 -0.069,-0.071 -0.079,-0.1463 -0.079,-0.24 0,0 0,-0.5969 0,-0.5969 0,0 -0.4572,0.2593 -0.4572,0.2593 -0.079,0.045 -0.1716,0.1005 -0.2667,0.092 -0.2123,-0.018 -0.3083,-0.254 -0.193,-0.4148 0.055,-0.077 0.1737,-0.1342 0.2565,-0.1815 0,0 0.381,-0.2123 0.381,-0.2123 0,0 0,-0.025 0,-0.025 0,0 -0.4064,-0.225 -0.4064,-0.225 -0.076,-0.043 -0.1825,-0.097 -0.233,-0.1687 -0.1245,-0.1758 0.01,-0.4176 0.2203,-0.4168 0.088,2e-4 0.1928,0.065 0.2667,0.1095 0,0 0.4318,0.2438 0.4318,0.2438 z m 2.921,0 c 0,0 0,-0.5842 0,-0.5842 10e-5,-0.085 0.01,-0.1735 0.066,-0.2408 0.1147,-0.1302 0.3371,-0.1135 0.4261,0.038 0.03,0.051 0.04,0.1438 0.041,0.2032 0,0 0,0.5842 0,0.5842 0,0 0.4445,-0.2521 0.4445,-0.2521 0.084,-0.048 0.1786,-0.1045 0.2794,-0.097 0.212,0.016 0.3091,0.2505 0.193,0.4124 -0.053,0.074 -0.1417,0.1147 -0.2184,0.1601 -0.091,0.054 -0.3344,0.2026 -0.4191,0.2337 0,0 0,0.025 0,0.025 0,0 0.4318,0.2412 0.4318,0.2412 0.079,0.046 0.1629,0.085 0.2143,0.1652 0.114,0.1782 -0.025,0.4211 -0.2397,0.4022 -0.093,-0.01 -0.175,-0.062 -0.254,-0.1065 0,0 -0.4318,-0.2449 -0.4318,-0.2449 0,0 0,0.5842 0,0.5842 -10e-5,0.078 -0.01,0.1646 -0.056,0.2281 -0.1073,0.1356 -0.3304,0.1368 -0.4269,-0.012 -0.042,-0.065 -0.05,-0.1407 -0.05,-0.2159 0,0 0,-0.5842 0,-0.5842 0,0 -0.4445,0.2521 -0.4445,0.2521 -0.083,0.047 -0.18,0.1081 -0.2794,0.099 -0.2123,-0.018 -0.3083,-0.254 -0.193,-0.4148 0.055,-0.077 0.1737,-0.1342 0.2565,-0.1815 0,0 0.381,-0.2123 0.381,-0.2123 0,0 0,-0.025 0,-0.025 0,0 -0.4318,-0.2412 -0.4318,-0.2412 -0.074,-0.043 -0.1571,-0.081 -0.2076,-0.1525 -0.1202,-0.1716 5e-4,-0.4079 0.2076,-0.4178 0.092,0 0.1886,0.058 0.2667,0.1022 0,0 0.4445,0.2521 0.4445,0.2521 z m 3.7465,3.5107 c 0.1685,-0.021 0.3823,0 0.5207,0.1028 0.2757,0.2128 0.3023,0.7286 0.025,0.9519 -0.1464,0.118 -0.3049,0.1229 -0.4825,0.1209 -0.1389,0 -0.2934,-0.052 -0.3915,-0.1535 -0.2349,-0.2424 -0.2036,-0.7133 0.061,-0.921 0.078,-0.061 0.1715,-0.085 0.2667,-0.1011 z"/>
				</g>
			</g>
		</svg>
	},
	attributes: {
		redirect_url : {
			type: 'string',
			default: '',
		},
		is_preview : {
			type: 'boolean',
			default: false,
		},
		is_editor : {
			type: 'boolean',
			default: true,
		},
	},
	/**
	 * @see ./edit.js
	 */
	edit : Edit,
} );